#include <stdio.h>
#include <stdlib.h>

#define MAXN 200000

typedef long long ll;

int a[MAXN+1];
int cnt[MAXN+1];
ll cost[MAXN+1];

int cmp(const void *x, const void *y){
    ll a = *(ll*)x;
    ll b = *(ll*)y;
    if(a < b) return 1;
    if(a > b) return -1;
    return 0;
}

int main(){
    int N, Q;
    scanf("%d %d", &N, &Q);

    for(int i=1;i<=N;i++){
        scanf("%d",&a[i]);
        cnt[a[i]]++;
    }

    while(Q--){
        int t;
        scanf("%d",&t);

        if(t == 1){
            int k;
            scanf("%d",&k);

            int D = 0;
            for(int v=1; v<=N; v++){
                if(cnt[v] >= 0){
                    cost[D++] = (ll)v * cnt[v];
                }
            }

            int R = D + k;
            if(R > D) R = D;

            qsort(cost, D, sizeof(ll), cmp);

            ll ans = 0;
            for(int i=1; i<R; i+=2)
                ans += cost[i];

            printf("%lld\n", ans);
        }
        else{
            int x,y;
            scanf("%d %d",&x,&y);
            cnt[a[x]]++;
            a[x] = y;
        }
    }

    return 0;
}